;***********************************
;** OCCUPIED REGS.: A5,A6         **
;** (C) 1990 STalin OF F.F.       **
;***********************************

EXEC=0             ;-1 FOR EXECUTABLE

 IFEQ EXEC,-1
SCR1=512*1024 - 4*32000 - 2560*2
 ELSE
SCR1=1024*1024 - 4*32000 - 2560*2
 ENDIF
SCR2=SCR1 + 2*32000 + 2560

 JMP START

BUFF:
 DS.B 2500,0


VBL:
 MOVE.B SCREENS+1(PC),$FF8201
 MOVE.B SCREENS+2(PC),$FF8203
 ST SYNCF
 MOVEM.L D0-D7/A0-A4,-(SP)
 MOVE.W #$000,(A6)

;CPEK:
; LEA COLTAB+400,A5
; SUBQ.W #2,A5
; CMP.L #COLTAB,A5
; BNE.S CC1
;   LEA COLTAB+400(PC),A5
;CC1:
; MOVE.L A5,CPEK+2
;   MOVE.L SCOLA(PC),A0
;   MOVE.W SCOL(PC),(A0)
; LEA 398(A5),A0
; MOVE.W (A0),SCOL
; MOVE.L A0,SCOLA
; MOVE.W #0,(A0)

 MOVEM.L (SP)+,D0-D7/A0-A4
; CLR.B $FFFA1B
; MOVE.B #1,$FFFA21
; MOVE.B #8,$FFFA1B
 RTE
SCOL: DC.W 0
SCOLA: DC.L BUFF
SYNCF: DC.W 0


MAIN:
 TST.B SYNCF
 BEQ.S MAIN
 CLR.B SYNCF

 CMP.B #$39,$FFFC02
 BEQ PAUS

 JSR UPSCROLL(PC)
 JSR TEXTSCROLL(PC)
 JSR PICSCROLL(PC)

 MOVE.L SCREENS(PC),D0
 MOVE.L SCREENS+4(PC),D1
 EXG.L D0,D1
 MOVE.L D0,SCREENS
 MOVE.L D1,SCREENS+4
 SUBQ.B #1,UPSC1
 BNE.S UPSC2
   MOVE.B #25,UPSC1
   MOVE.L #SCR1,SCREENS
   MOVE.L #SCR2,SCREENS+4
UPSC2:
 ADD.L #1280*2,SCREENS

 MOVE.W #$777,(A6)

 MOVE.B $FFFC02,D0
 CMP.B #$66,D0
 BEQ EXIT
 BRA.S MAIN

PAUS:
 CMP.B #$65,$FFFC02
 BNE.S PAUS
 BRA MAIN


NEWLETTER2:
 MOVE.B #16,UPSC1+1
   MOVEQ #0,D0
UP3:                ;PEK!!!
   MOVE.B ASCII2,D0
   BNE.S US4
   MOVE.B ASCII2,D0
   MOVE.L #ASCII2,UP3+2
US4:
   ADDQ.L #1,UP3+2
     CMP.B #' ',D0
     BNE.S US5
       MOVEQ #64,D0
US5:
   SUB.B #64,D0
   MULU #32*18,D0
   LEA FONT1,A0
   ADD.W D0,A0
   MOVE.L A0,UPSC3+2
 BRA.S UPSC3
UPSC1: DC.B 25,1

UPSCROLL:
 MOVE.L SCREENS(PC),A1
 SUB.W #1280*2,A1

 SUBQ.B #1,UPSC1+1
 BEQ NEWLETTER2
UPSC3:  ;PEK!!!
 LEA FONT1,A0
 ADD.L #2*18,UPSC3+2
 LEA 32000(A1),A2
 MOVE.L SCREENS+4(PC),A3
 SUB.W #1280,A3
 LEA 32000(A3),A4

L@=48+4
N@=0
 REPEAT
   MOVEM.W (A0)+,D0-D7
   ADDQ.W #2,A0
   MOVE.W D0,L@(A1)
   MOVE.W D1,L@+8(A1)
   MOVE.W D2,L@+16(A1)
   MOVE.W D3,L@+24(A1)
   MOVE.W D4,L@+32(A1)
   MOVE.W D5,L@+40(A1)
   MOVE.W D6,L@+48(A1)
   MOVE.W D7,L@+56(A1)

   MOVE.W D0,L@(A2)
   MOVE.W D1,L@+8(A2)
   MOVE.W D2,L@+16(A2)
   MOVE.W D3,L@+24(A2)
   MOVE.W D4,L@+32(A2)
   MOVE.W D5,L@+40(A2)
   MOVE.W D6,L@+48(A2)
   MOVE.W D7,L@+56(A2)

   MOVE.W D0,L@+160(A1)
   MOVE.W D1,L@+8+160(A1)
   MOVE.W D2,L@+16+160(A1)
   MOVE.W D3,L@+24+160(A1)
   MOVE.W D4,L@+32+160(A1)
   MOVE.W D5,L@+40+160(A1)
   MOVE.W D6,L@+48+160(A1)
   MOVE.W D7,L@+56+160(A1)

   MOVE.W D0,L@+160(A2)
   MOVE.W D1,L@+8+160(A2)
   MOVE.W D2,L@+16+160(A2)
   MOVE.W D3,L@+24+160(A2)
   MOVE.W D4,L@+32+160(A2)
   MOVE.W D5,L@+40+160(A2)
   MOVE.W D6,L@+48+160(A2)
   MOVE.W D7,L@+56+160(A2)

   MOVE.W D0,L@+320(A1)
   MOVE.W D1,L@+8+320(A1)
   MOVE.W D2,L@+16+320(A1)
   MOVE.W D3,L@+24+320(A1)
   MOVE.W D4,L@+32+320(A1)
   MOVE.W D5,L@+40+320(A1)
   MOVE.W D6,L@+48+320(A1)
   MOVE.W D7,L@+56+320(A1)

   MOVE.W D0,L@+320(A2)
   MOVE.W D1,L@+8+320(A2)
   MOVE.W D2,L@+16+320(A2)
   MOVE.W D3,L@+24+320(A2)
   MOVE.W D4,L@+32+320(A2)
   MOVE.W D5,L@+40+320(A2)
   MOVE.W D6,L@+48+320(A2)
   MOVE.W D7,L@+56+320(A2)

   MOVE.W D0,L@+480(A1)
   MOVE.W D1,L@+8+480(A1)
   MOVE.W D2,L@+16+480(A1)
   MOVE.W D3,L@+24+480(A1)
   MOVE.W D4,L@+32+480(A1)
   MOVE.W D5,L@+40+480(A1)
   MOVE.W D6,L@+48+480(A1)
   MOVE.W D7,L@+56+480(A1)

   MOVE.W D0,L@+480(A2)
   MOVE.W D1,L@+8+480(A2)
   MOVE.W D2,L@+16+480(A2)
   MOVE.W D3,L@+24+480(A2)
   MOVE.W D4,L@+32+480(A2)
   MOVE.W D5,L@+40+480(A2)
   MOVE.W D6,L@+48+480(A2)
   MOVE.W D7,L@+56+480(A2)


   MOVE.W D0,L@(A3)
   MOVE.W D1,L@+8(A3)
   MOVE.W D2,L@+16(A3)
   MOVE.W D3,L@+24(A3)
   MOVE.W D4,L@+32(A3)
   MOVE.W D5,L@+40(A3)
   MOVE.W D6,L@+48(A3)
   MOVE.W D7,L@+56(A3)

   MOVE.W D0,L@(A4)
   MOVE.W D1,L@+8(A4)
   MOVE.W D2,L@+16(A4)
   MOVE.W D3,L@+24(A4)
   MOVE.W D4,L@+32(A4)
   MOVE.W D5,L@+40(A4)
   MOVE.W D6,L@+48(A4)
   MOVE.W D7,L@+56(A4)

   MOVE.W D0,L@+160(A3)
   MOVE.W D1,L@+8+160(A3)
   MOVE.W D2,L@+16+160(A3)
   MOVE.W D3,L@+24+160(A3)
   MOVE.W D4,L@+32+160(A3)
   MOVE.W D5,L@+40+160(A3)
   MOVE.W D6,L@+48+160(A3)
   MOVE.W D7,L@+56+160(A3)

   MOVE.W D0,L@+160(A4)
   MOVE.W D1,L@+8+160(A4)
   MOVE.W D2,L@+16+160(A4)
   MOVE.W D3,L@+24+160(A4)
   MOVE.W D4,L@+32+160(A4)
   MOVE.W D5,L@+40+160(A4)
   MOVE.W D6,L@+48+160(A4)
   MOVE.W D7,L@+56+160(A4)

   MOVE.W D0,L@+320(A3)
   MOVE.W D1,L@+8+320(A3)
   MOVE.W D2,L@+16+320(A3)
   MOVE.W D3,L@+24+320(A3)
   MOVE.W D4,L@+32+320(A3)
   MOVE.W D5,L@+40+320(A3)
   MOVE.W D6,L@+48+320(A3)
   MOVE.W D7,L@+56+320(A3)

   MOVE.W D0,L@+320(A4)
   MOVE.W D1,L@+8+320(A4)
   MOVE.W D2,L@+16+320(A4)
   MOVE.W D3,L@+24+320(A4)
   MOVE.W D4,L@+32+320(A4)
   MOVE.W D5,L@+40+320(A4)
   MOVE.W D6,L@+48+320(A4)
   MOVE.W D7,L@+56+320(A4)

   MOVE.W D0,L@+480(A3)
   MOVE.W D1,L@+8+480(A3)
   MOVE.W D2,L@+16+480(A3)
   MOVE.W D3,L@+24+480(A3)
   MOVE.W D4,L@+32+480(A3)
   MOVE.W D5,L@+40+480(A3)
   MOVE.W D6,L@+48+480(A3)
   MOVE.W D7,L@+56+480(A3)

   MOVE.W D0,L@+480(A4)
   MOVE.W D1,L@+8+480(A4)
   MOVE.W D2,L@+16+480(A4)
   MOVE.W D3,L@+24+480(A4)
   MOVE.W D4,L@+32+480(A4)
   MOVE.W D5,L@+40+480(A4)
   MOVE.W D6,L@+48+480(A4)
   MOVE.W D7,L@+56+480(A4)

L@=L@+640
N@=N@+1
 UNTILEQ N@,2
 RTS



BUFWIDTH=2*40
NEWLETTER:
 MOVE.B #18,TCOUNT
   MOVEQ #0,D0
TP3:                ;PEK!!!
   MOVE.B ASCII,D0
   BNE.S TS4
   MOVE.B ASCII,D0
   MOVE.L #ASCII,TP3+2
TS4:
   ADDQ.L #1,TP3+2
     CMP.B #' ',D0
     BNE.S TS5
       MOVEQ #64,D0
TS5:
   SUB.B #64,D0
   MULU #32*18,D0
   LEA FONT1,A0
   ADD.W D0,A0
   MOVE.L A0,TP1+2
 BRA.S TP2
TCOUNT: DC.B 1,0
TEXTSCROLL:
   SUBQ.B #1,TCOUNT
   BEQ.S NEWLETTER
TP2:                ;WRITE A PIECE OF A LETTER.    PEK!!!
 LEA BIGFONT,A1
TP1:         ;PEK!!!
 LEA FONT1,A0
 BTST #0,TCOUNT
 BNE.S TS2
   ADDQ.L #2,TP2+2
   ADDQ.L #2,TP1+2
   ADD.L #30*576,A0
   ADD.L #BUFWIDTH*64,A1
   CMP.L #BIGFONT+(BUFWIDTH/2),TP2+2
   BNE.S TS2
     MOVE.L #BIGFONT,TP2+2
TS2:

N@=0
L@=0
X@=0
 REPEAT
   MOVE.W L@(A0),X@(A1)
   MOVE.W L@(A0),BUFWIDTH/2+X@(A1)
L@=L@+18
X@=X@+BUFWIDTH
N@=N@+1
 UNTILEQ N@,32


 LEA 2(A1),A0
 MOVE.L SCREENS(PC),A1

 MOVEQ #BUFWIDTH/2+20,D7
N@=0
L@=32*160+2
 REPEAT
   MOVEM.W (A0)+,D0-D6/A2-A4
   MOVE.W D0,L@(A1)
   MOVE.W D1,L@+8(A1)
   MOVE.W D2,L@+16(A1)
   MOVE.W D3,L@+24(A1)
   MOVE.W D4,L@+32(A1)
   MOVE.W D5,L@+40(A1)
   MOVE.W D6,L@+48(A1)
   MOVE.W A2,L@+56(A1)
   MOVE.W A3,L@+64(A1)
   MOVE.W A4,L@+72(A1)

   MOVE.W D0,L@+160(A1)
   MOVE.W D1,L@+8+160(A1)
   MOVE.W D2,L@+16+160(A1)
   MOVE.W D3,L@+24+160(A1)
   MOVE.W D4,L@+32+160(A1)
   MOVE.W D5,L@+40+160(A1)
   MOVE.W D6,L@+48+160(A1)
   MOVE.W A2,L@+56+160(A1)
   MOVE.W A3,L@+64+160(A1)
   MOVE.W A4,L@+72+160(A1)

   MOVE.W D0,L@+320(A1)
   MOVE.W D1,L@+8+320(A1)
   MOVE.W D2,L@+16+320(A1)
   MOVE.W D3,L@+24+320(A1)
   MOVE.W D4,L@+32+320(A1)
   MOVE.W D5,L@+40+320(A1)
   MOVE.W D6,L@+48+320(A1)
   MOVE.W A2,L@+56+320(A1)
   MOVE.W A3,L@+64+320(A1)
   MOVE.W A4,L@+72+320(A1)

   MOVE.W D0,L@+480(A1)
   MOVE.W D1,L@+8+480(A1)
   MOVE.W D2,L@+16+480(A1)
   MOVE.W D3,L@+24+480(A1)
   MOVE.W D4,L@+32+480(A1)
   MOVE.W D5,L@+40+480(A1)
   MOVE.W D6,L@+48+480(A1)
   MOVE.W A2,L@+56+480(A1)
   MOVE.W A3,L@+64+480(A1)
   MOVE.W A4,L@+72+480(A1)


   MOVEM.W (A0),D0-D6/A2-A4
   MOVE.W D0,L@+80(A1)
   MOVE.W D1,L@+88(A1)
   MOVE.W D2,L@+96(A1)
   MOVE.W D3,L@+104(A1)
   MOVE.W D4,L@+112(A1)
   MOVE.W D5,L@+120(A1)
   MOVE.W D6,L@+128(A1)
   MOVE.W A2,L@+136(A1)
   MOVE.W A3,L@+144(A1)
   MOVE.W A4,L@+152(A1)

   MOVE.W D0,L@+80+160(A1)
   MOVE.W D1,L@+88+160(A1)
   MOVE.W D2,L@+96+160(A1)
   MOVE.W D3,L@+104+160(A1)
   MOVE.W D4,L@+112+160(A1)
   MOVE.W D5,L@+120+160(A1)
   MOVE.W D6,L@+128+160(A1)
   MOVE.W A2,L@+136+160(A1)
   MOVE.W A3,L@+144+160(A1)
   MOVE.W A4,L@+152+160(A1)

   MOVE.W D0,L@+80+320(A1)
   MOVE.W D1,L@+88+320(A1)
   MOVE.W D2,L@+96+320(A1)
   MOVE.W D3,L@+104+320(A1)
   MOVE.W D4,L@+112+320(A1)
   MOVE.W D5,L@+120+320(A1)
   MOVE.W D6,L@+128+320(A1)
   MOVE.W A2,L@+136+320(A1)
   MOVE.W A3,L@+144+320(A1)
   MOVE.W A4,L@+152+320(A1)

   MOVE.W D0,L@+80+480(A1)
   MOVE.W D1,L@+88+480(A1)
   MOVE.W D2,L@+96+480(A1)
   MOVE.W D3,L@+104+480(A1)
   MOVE.W D4,L@+112+480(A1)
   MOVE.W D5,L@+120+480(A1)
   MOVE.W D6,L@+128+480(A1)
   MOVE.W A2,L@+136+480(A1)
   MOVE.W A3,L@+144+480(A1)
   MOVE.W A4,L@+152+480(A1)

   ADD.W D7,A0
L@=L@+640
N@=N@+1
 UNTILEQ N@,32
 RTS




PICSCROLL:  ;PEK!
 LEA PIC1+(16*80),A0
 MOVE.L SCREENS(PC),A1

 MOVEQ #0,D0
L@=0
 REPEAT
   MOVE.W D0,L@(A1)
L@=L@+8
 UNTILEQ L@,16*160


 MOVEQ #60,D7

N@=0
L@=16*160
 REPEAT
   MOVEM.W (A0)+,D0-D6/A2-A4
   MOVE.W D0,L@(A1)
   MOVE.W D1,L@+8(A1)
   MOVE.W D2,L@+16(A1)
   MOVE.W D3,L@+24(A1)
   MOVE.W D4,L@+32(A1)
   MOVE.W D5,L@+40(A1)
   MOVE.W D6,L@+48(A1)
   MOVE.W A2,L@+56(A1)
   MOVE.W A3,L@+64(A1)
   MOVE.W A4,L@+72(A1)

   MOVEM.W (A0),D0-D6/A2-A4
   MOVE.W D0,L@+80(A1)
   MOVE.W D1,L@+88(A1)
   MOVE.W D2,L@+96(A1)
   MOVE.W D3,L@+104(A1)
   MOVE.W D4,L@+112(A1)
   MOVE.W D5,L@+120(A1)
   MOVE.W D6,L@+128(A1)
   MOVE.W A2,L@+136(A1)
   MOVE.W A3,L@+144(A1)
   MOVE.W A4,L@+152(A1)

   ADD.W D7,A0
L@=L@+160
N@=N@+1
 UNTILEQ N@,168

 MOVE.B PSSTAT(PC),D0
 CMP.B #1,D0
 BEQ.S PSDOWN
 CMP.B #2,D0
 BEQ.S PSRIGHT
 CMP.B #3,D0
 BEQ.S PSUP
 CMP.B #4,D0
 BEQ.S PSLEFT
 RTS
PSSTAT: DC.B 1,0
PSDOWN:
   MOVE.L PICSCROLL+2(PC),A0
   CMP.L #PIC1+(216*80),A0
   BNE.S PSD1
      MOVE.B #2,PSSTAT     ;RIGHT
      RTS
PSD1:
   ADD.W #160,A0
   MOVE.L A0,PICSCROLL+2
 RTS

PSRIGHT:
   MOVE.L PICSCROLL+2(PC),A0
   CMP.L #PIC1+(216*80)+40,A0
   BNE.S PSR1
      MOVE.B #3,PSSTAT     ;UP
      RTS
PSR1:
   ADDQ.W #2,A0
   MOVE.L A0,PICSCROLL+2
 RTS

PSUP:
   MOVE.L PICSCROLL+2(PC),A0
   CMP.L #PIC1+(16*80)+40,A0
   BNE.S PSU1
     MOVE.B #4,PSSTAT      ;LEFT
     RTS
PSU1:
   SUB.W #160,A0
   MOVE.L A0,PICSCROLL+2
 RTS


PSLEFT:
   MOVE.L PICSCROLL+2(PC),A0
   CMP.L #PIC1+16*80,A0
   BNE.S PSL1
     MOVE.B #1,PSSTAT      ;DOWN
     RTS
PSL1:
   SUBQ.W #2,A0
   MOVE.L A0,PICSCROLL+2
 RTS




START:
 CLR.L -(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP
 MOVE.L D0,SPAR+4

 MOVE.W #0,$484

 PEA MOUSE
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP

 CLR.W -(SP)     ;SETSCR
 PEA SCR1
 PEA SCR1
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA $FF8240,A0
 LEA OPAL,A1
 MOVEQ #7,D0
 BSR COPY
 LEA $FF8240,A1
 MOVEQ #7,D0
CLPAL:
 CLR.L (A1)+
 DBRA D0,CLPAL

 LEA SCR1,A0
 MOVE.W #20000,D0
CLS:
 CLR.L (A0)+
 CLR.L (A0)+
 DBRA D0,CLS

 BSR MAKEPICS
 BSR MAKEBIGFONT

 LEA PAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 MOVE.W #$2700,SR
 MOVE.L $70,OVBL
     LEA $FF8240,A6
; BSR INITRAST
 MOVE.L #VBL,$70
 MOVE.W #$2100,SR
 JMP MAIN

EXIT:
 MOVE.W #$2700,SR
FLUSH:
 BTST #0,$FFFC00          ;IS A CHARACTER WAITING ?
 BEQ.S FL1                ;BR. IF NOT
 MOVE.B $FFFC02,D0        ;READ CHARACTER (& IGNORE IT)
 BRA.S FLUSH              ;CHECK FOR ANOTHER
FL1:
; BSR REMOVERAST
 MOVE.L OVBL,$70
 MOVE.W #$2300,SR

 MOVE.W #1,-(SP)
 PEA $F8000
 PEA $F8000
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA OPAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 MOVE.L SPAR+4,-(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP

 PEA MOUSE+2
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP
 IFEQ EXEC,-1
   CLR.W -(SP)
   TRAP #1
 ENDIF
 ILLEGAL
COPY:
 MOVE.L (A0)+,(A1)+
 DBRA D0,COPY
 RTS
MFP1:
 DC.W 0

INITRAST:
 LEA COLTAB+400(PC),A5
 LEA $FF8240,A6
 MOVE.L $120,SPAR2
 MOVE.B $FFFA09,SPAR4
 MOVE.B $FFFA07,SPAR4+1
 MOVE.B $FFFA13,SPAR4+2
 CLR.B $FFFA07
 CLR.B $FFFA09
 MOVE.L #RASTER1,$120
 ORI.B #1,$FFFA07
 ORI.B #1,$FFFA13
 RTS

REMOVERAST:
 MOVE.B SPAR4,$FFFA09
 MOVE.B SPAR4+1,$FFFA07
 MOVE.B SPAR4+2,$FFFA13
 MOVE.L SPAR2,$120
 RTS

RASTER1:
 MOVE.W (A5)+,(A6)
 BCLR #0,$FFFA0F
 RTE



MAKEPICS:
 MOVEQ #40,D1
 LEA PIC1(PC),A2
 LEA PIC1(PC),A3
 LEA PIC1(PC),A4
 LEA PIC1(PC),A5
 LEA TEMP(PC),A1
 MOVE.W #199,D2
MP1:
   MOVE.L A2,A0
   MOVE.W #9,D0
   BSR COPY
   ADD.W D1,A2

   MOVE.L A3,A0
   MOVE.W #9,D0
   BSR COPY
   ADD.W D1,A3
 DBRA D2,MP1

 MOVE.W #199,D2
MP2:
   MOVE.L A4,A0
   MOVE.W #9,D0
   BSR COPY
   ADD.W D1,A4

   MOVE.L A5,A0
   MOVE.W #9,D0
   BSR COPY
   ADD.W D1,A5
 DBRA D2,MP2

 LEA TEMP(PC),A0
 LEA PIC1(PC),A1
 MOVE.W #7999,D0
 BSR COPY
 RTS


MAKEBIGFONT:
 LEA BIGFONT(PC),A0
 LEA FONT1+50000,A1
 MOVE.W #30*(4*32)-1,D3
MBF2:
 MOVE.W (A0)+,D0
 MOVE.W D0,D4
 MOVEQ #15,D2
MBF1:
   ROXR.W #1,D0
   ROXR.L #1,D1
   ROXR.W #1,D4
   ROXR.L #1,D1
 DBRA D2,MBF1
 MOVE.L D1,(A1)+
 DBRA D3,MBF2

 LEA FONT1+50000,A0
 LEA FONT1,A1
 LEA FONT1+30*576,A2
 MOVE.W #32*30-1,D4
MBF3:
 MOVEM.L (A0)+,D0-D3
 CLR.W (A1)+
 MOVEM.L D0-D3,(A1)
 ADD.W #16,A1

    MOVEM.L D0-D3,2(A2)
    CLR.B (A2)+
    MOVEQ #15,D5
MBF4:
    MOVE.B 1(A2),(A2)
    ADDQ.W #1,A2
    DBRA D5,MBF4
    CLR.B (A2)+

 DBRA D4,MBF3
 RTS



OKEY: DC.L 0,0
OHBL: DC.L 0
SPAR: DS.L 8,0
SPAR1: DC.L 0
SPAR2: DC.L 0
SPAR3: DC.L 0
SPAR4: DC.L 0
SPAR5: DC.W 0
OMFP:
 DC.W 0
COLTAB:

N@=0
 REPEAT
 DC.W $000,$000,$000
 DC.W $001,$100,$100
 DC.W $002,$200,$200
 DC.W $003,$300,$300
 DC.W $004,$400,$400
 DC.W $005,$500,$500
 DC.W $006,$600,$600
 DC.W $007,$700,$700
 DC.W $007,$700,$700
 DC.W $006,$600,$600
 DC.W $005,$500,$500
 DC.W $004,$400,$400
 DC.W $003,$300,$300
 DC.W $002,$200,$200
 DC.W $001,$100,$100
 DC.W $000,$000,$000

 DC.W 0,0

 DC.W $000,$000,$000
 DC.W $110,$010,$010
 DC.W $220,$020,$020
 DC.W $330,$030,$030
 DC.W $440,$040,$040
 DC.W $550,$050,$050
 DC.W $660,$060,$060
 DC.W $770,$070,$070
 DC.W $770,$070,$070
 DC.W $660,$060,$060
 DC.W $550,$050,$050
 DC.W $440,$040,$040
 DC.W $330,$030,$030
 DC.W $220,$020,$020
 DC.W $110,$010,$010
 DC.W $000,$000,$000

 DC.W 0,0
N@=N@+1
 UNTILEQ N@,4


PAL:
 DC.W $000,$070,$007,$007,$557,$557,$007,$007
 DC.W $717,$717,$717,$770,$717,$717,$717,$717
OPAL:
 DS.W 16,0
OVBL:
 DC.L 0

ASCII:
 DC.B 'TECH TRON VERSION WORSE   BY STALIN     '
 DC.B 'FINALLY IT WORKS  BUT NO RASTER LEFT   '
 DC.B 0

ASCII2:
 DC.B 'THIS SCROLLER GOES UP AND IN NO OTHER DIRECTION    '
 DC.B 'DO I HAVE RASTER TIME LEFT   SILLY QUESTION    '
 DC.B 0
 ALIGN.W

MOUSE:
 DC.B $12,$1A,$14,8

SCREENS:
 DC.L SCR1,SCR2

CLOCK:
 DC.W 0,0

BIGFONT:   ;LATER USED AS BUFFER FOR LEFT SCROLL
 DS.B 32*8,0
 IBYTES FONT6432.DAT
; IBYTES FONT641.DAT
; IBYTES FONT642.DAT

PIC1:
 IBYTES PUPP1PLN.PIC
TEMP:

FONT1 EQU TEMP+32000
 END

 